#ifndef OURDREAM_2D_SPRITESYSTEM_H
#define OURDREAM_2D_SPRITESYSTEM_H

#include "ComDef.h"
#include "IInterface.h"
#include "RenderSystem.h"
#include <math.h>

// 徫
struct SSprite
{
	int m_iID;
	float m_fX;
	float m_fY;
	float m_fWidth;
	float m_fHeigh;
	int m_iTexID;
	float m_fTexX;
	float m_fTexY;
	float m_fTexWidth;
	float m_fTexHeigh;
	DWORD m_dColor;
	float m_fAngle;
	float m_fScale;

	void Init(void)
	{
		m_iID=0;
		m_fX=0;
		m_fY=0;
		m_fWidth=0;
		m_fHeigh=0;
		m_iTexID=0;
		m_fTexX=0;
		m_fTexY=0;
		m_fTexWidth=0;
		m_fTexHeigh=0;
		m_dColor=ARGB(255, 255, 255, 255);
		m_fAngle=0;
		m_fScale=1;
	}

	void Init(int ID, float x, float y, float width, float heigh, 
				int texID, float texx, float texy, float texwidth, float texheigh, 
				DWORD color, float angle, float scale)
	{
		m_iID=ID;
		m_fX=x;
		m_fY=y;
		m_fWidth=width;
		m_fHeigh=heigh;
		m_iTexID=texID;
		m_fTexX=texx;
		m_fTexY=texy;
		m_fTexWidth=texwidth;
		m_fTexHeigh=texheigh;
		m_dColor=color;
		m_fAngle=angle;
		m_fScale=scale;

		if (m_fScale==0)
		{
			m_fScale=1;
		}
	}

};

// 徫ӿ
class ISpriteSystem : public IInterface
{
public:
	virtual void CALL CreatSprite(SSprite sprite)=0;
	virtual int CALL OnEven(void)=0;
	virtual void CALL Pause(void)=0;
	virtual void CALL Play(void)=0;
	virtual bool CALL IsPause(void)=0;
	virtual void CALL Release(void)=0;
	virtual void CALL Render(void)=0;

	virtual SSprite CALL GetSprite(void)=0;
	virtual SSprite CALL GetOriginalSprite(void)=0;
	virtual void CALL SetSprite(SSprite sprite)=0;
	virtual void CALL SetColor(DWORD color)=0;
	virtual DWORD CALL GetColor(void)=0; 
	virtual DWORD CALL GetOriginalColor(void)=0;
	virtual void CALL SetEven(OD2DCallback fun)=0;
	virtual OD2DCallback CALL GetEven(void)=0;

	virtual void CALL MoveTo(float step_x, bool reciprocate_x, float min_x, float max_x, 
							float step_y, bool reciprocate_y, float min_y, float max_y)=0;
	virtual void CALL MoveTo_EX(float step, float to_x, float to_y)=0;
	virtual void CALL Rotate(float angle)=0;
	virtual void CALL Flash(float rate)=0;
	virtual void CALL Disappear(DWORD step)=0;
	virtual void CALL Appear(DWORD step)=0;
	virtual void CALL Zoom(float rate)=0;
	virtual void CALL Kill(void)=0;
	virtual bool CALL IsKilled(void)=0;
	virtual void CALL Revive(void)=0;

};

#endif